/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: TCP
 * Filename: ImagePanel.java
 * Author: Gunter Weiss
 * Contents: Loads images and places these images in a panel
 * Last Changes: Gunter Weiss 07/97
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Event;
import Pict;

/******************************************************************************
* Class: ImagesPanel
* Description: Loads images and places these images in a panel
******************************************************************************/
public class ImagePanel extends Panel {
  Image image;
  String file;
  int size, dx, dy, dx1;
  TcpStarter starter;
  Pict pict ;

  public ImagePanel ( TcpStarter target, String ident ){
    starter=target;
    getPictures( ident );
    changeSize( 1 ,ident );
    setLayout( null );
    validate();
    show();
  }

/******************************************************************************
* Method      : paint
* Description : draws the image.
* Parameters  : the used graphic
* Return Value: none
******************************************************************************/
  public void paint( Graphics g ){
      g. drawImage( image, 0, 0, dx, dy, this );
  }

/******************************************************************************
* Method      : update
* Description : upates the graphics
* Parameters  : the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }

/******************************************************************************
* Method      : getPictures
* Description : loads the images.
* Parameters  : identifier for the kind of image.
* Return Value: none
******************************************************************************/
  public void getPictures( String ident ){
    if ( ident.equals("clientpict") ) {
      //file = "picts/client2.jpg";
      file = "picts/pro_dx.gif";
    } else
    if ( ident.equals("serverpict") ) {
       file = "picts/server2.jpg";
       //file = "picts/pri5xx.gif";
    } else
    if ( ident.equals("netpict") ) {
       file = "picts/net2.jpg";
    }
    if ( ident.equals("telnetpict") ) {
       file = "picts/telnet.jpg";
    }
    if ( ident.equals("telnet1pict") ) {
       file = "picts/telnet1.jpg";
    }
    if ( ident.equals("komm") ) {
       file = "picts/komm.jpg";
    }
    if ( ident.equals("ftppict") ) {
       file = "picts/ftp.jpg";
    }
    if ( ident.equals("athene") ) {
       file = "picts/athene.jpg";
    }
    if ( ident.equals("blitz") ) {
       file = "../picts/blitz.gif";
    }
    if ( ident.equals("Channel1") ) {
       file = "picts/kanal1.jpg";
    }
    if ( ident.equals("Channel12") ) {
       file = "picts/kanal12.jpg";
    }
    if ( ident.equals("Channel2") ) {
       file = "picts/kanal2.jpg";
    }
    if ( ident.equals("Channel22") ) {
       file = "picts/kanal22.jpg";
    }

    image = starter.grabimages.giveImage( file );
  }

/******************************************************************************
* Method: changeSize
* Description: scales the images and paints them
* Parameters: quality factor
* Return Value: none
******************************************************************************/
  public void changeSize( int qual , String ident){
    size = qual;
    ident = ident;
    if( ident!= "" ){
        resize(dx,dy);
        repaint();
        validate();
        getPictures(ident);
    }
    if( size == 1 ){
      dx = 80;  //factor 1
      dy = 70;
      dx1 = 60;
    }
    else if( size == 2 ){
      dx = 100;  //factor 1,25
      dy = 88;
      dx1 = 90;
    }
    else if( size == 3 ){
      dx = 128;  //factor 1,6
      dy = 112;
      dx1 = 120;
    }
    else if( size == 4 ){
      dx = 160;  //factor 2
      dy = 140;
      dx1 = 150;
    }
    if ( ident.equals( "netpict") ) {
      dx = dx * 2;
    }
    if ( ident.equals( "Channel1") ) {
      dx = dx * 2 + dx1;
      dy = 70;
    }
    if ( ident.equals( "Channel12") ) {
      dx = dx * 2 + dx1;
      dy = 70;
    }
    if ( ident.equals( "Channel2") ) {
      dx = dx * 2 + dx1;
      dy = 70;
    }
    if ( ident.equals( "Channel22") ) {
      dx = dx * 2 + dx1;
      dy = 70;
    }
    resize( dx, dy );
    repaint();
    validate();
  }
}












